/***************************************************************************
                          LOW_exception.h  -  description
                             -------------------
    begin                : Sat Jul 6 2002
    copyright            : (C) 2002 by Harald Roelle, Helmut Reiser
    email                : roelle@informatik.uni-muenchen.de, reiser@informatik.uni-muenchen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LOW_EXCEPTION_H
#define LOW_EXCEPTION_H

  
#include <string>

  

/** Macro for easy subclassing of LOW_exception.
 */
#define class_DERIVE_FROM_EXCEPTION(DERIVED,SUPER) \
  class DERIVED : public SUPER { \
    public: DERIVED( const std::string inMsg, const std::string inFile, const int inLine) : SUPER( inMsg, inFile, inLine) {};  \
            DERIVED( const int inErrNum, const std::string inMsg, const std::string inFile, const int inLine) : SUPER( inErrNum, inMsg, inFile, inLine) {}; \
  }


            
/** Base class for all exception of this library.

    @author Harald Roelle, Helmut Reiser
 */
class LOW_exception {

//=======================================================================================
public: 

  //=====================================================================================
  //
  // attributes
  //
  
  const int     errNum;   /**< OS error number. */
  const string  message;  /**< Descriptive message. */
  const string  file;     /**< File from which exception was thrown. */
  const int     line;     /**< Line number where exception was thrown. */
  
    
  //=====================================================================================
  //
  // constructors
  //

  /** Default constructor.
   */  
  LOW_exception();

  /** Constructor.
      @param  inMsg   Message describing the exception.
      @param  inFile  File from which exception is thrown.
      @param  inLine  Line number where exception is thrown.
   */
  LOW_exception( const std::string inMsg, const std::string inFile, const int inLine);

  /** Constructor for OS errors.

      The textual OS description (perror) is added automatically when exception is logged.
  
      @param  inErrNum  OS error number.
      @param  inMsg     Message describing the exception.
      @param  inFile    File from which exception is thrown.
      @param  inLine    Line number where exception is thrown.
   */
  LOW_exception( const int inErrNum, const std::string inMsg, const std::string inFile, const int inLine);
  
  /** Destructor.
   */
  ~LOW_exception();

  
  //=====================================================================================
  //
  // static methods
  //

  /** Set wether exceptions should be logged automatically when created.
      @param  inLogOnCreation   Wether exceptions should be logged automatically.
   */
  static void setLogOnCreation( const bool inLogOnCreation);

  /** Get wether exceptions are logged automatically when created.
      @return   Wether exceptions are logged automatically.
   */
  static bool getLogOnCreation();
  
  
  //=====================================================================================
  //
  // methods
  //

  /** Log the exception via LOW_helper_msglog::printError()
      @param  inPrefix  Prefix to prepend to the log message.
   */
  void logException( const std::string inPrefix = "");
      

//=======================================================================================
protected:

  //=====================================================================================
  //
  // static attributes
  //

  /** Inicates wether exception should be logged automatically when the are created. */
  static bool logOnCreation;
  
};

#endif
