/***************************************************************************
                          LOW_linkPassiveSerial.h  -  description
                             -------------------
    begin                : Sun Jul 7 2002
    copyright            : (C) 2002 by Harald Roelle, Helmut Reiser
    email                : roelle@informatik.uni-muenchen.de, reiser@informatik.uni-muenchen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LOW_LINKPASSIVESERIAL_H
#define LOW_LINKPASSIVESERIAL_H

 
#include "LOW_types.h"
#include "LOW_link.h"
#include "LOW_exception.h"
#include "LOW_portSerial.h"


    
/** Link class for simple passive serial 1-Wire adapters.

    As the passive adapter is not capable of real strong pullups with high current,
    it is emulated by providing high level on the bus for a relatively long time.
    
    @author Harald Roelle, Helmut Reiser
*/
class LOW_linkPassiveSerial : public LOW_link  {

//=======================================================================================
public: 

  //=====================================================================================
  //
  // constructors
  //
  
  /** Constructor.

      @param  inSerPortSpec       Specification of serial port the adapter is on.
      @param  inAllowProgPulse    Wether the program pulse should be allowed.
   */
  LOW_linkPassiveSerial( const LOW_portSerialFactory::portSpecifier_t &inSerPortSpec,
                         const bool inAllowProgPulse = false);

  /** Destructor.
   */
  ~LOW_linkPassiveSerial();

  
  //=====================================================================================
  //
  // Standard methods required by LOW_Link
  //
  
  //! @name Bus touch (write/read) methods required by LOW_Link
  //!@{
  bool touchBit( const bool inSendBit, const strongPullup_t inPullup = pullUp_NONE);
  uint8_t touchByte( const uint8_t inSendByte, const strongPullup_t inPullup = pullUp_NONE);
  byteVec_t touchBlock( const byteVec_t &inBytes, const strongPullup_t inPullup = pullUp_NONE);
  //!@}

  //! @name Bus read methods required by LOW_Link
  //!@{
  bool readDataBit( const strongPullup_t inPullup = pullUp_NONE);
  uint8_t readDataByte( const strongPullup_t inPullup = pullUp_NONE);
  void readData( byteVec_t &outBytes, const strongPullup_t inPullup = pullUp_NONE);
  //!@}

  //! @name Bus write methods required by LOW_Link
  //!@{
  void writeData( const bool inSendBit, const strongPullup_t inPullup = pullUp_NONE);
  void writeData( const uint8_t inSendByte, const strongPullup_t inPullup = pullUp_NONE);
  void writeData( const byteVec_t &inSendBytes, const strongPullup_t inPullup = pullUp_NONE);
  //!@}

  //! @name Misc methods required by LOW_Link
  //!@{
  void resetLinkAdapter();
  bool resetBus();
  void strongPullup( const unsigned long inMicroSecs);
  void programPulse();
  void doSearchSequence( const LOW_deviceIDRaw &inBranchVector,
                         LOW_deviceIDRaw &outFoundID, LOW_deviceIDRaw &outDiscrVec);
  //!@}

    
//=======================================================================================
private:

  //=====================================================================================
  //
  // constants
  //

  /** Time to wait for emulation of strong pullup in seconds. */
  static const int strongPullupEmuTime = 3;

    
  //=====================================================================================
  //
  // attributes
  //
  
  LOW_portSerial   *serialPort;   /**< The serial port the adapter is attached to. */


  //=====================================================================================
  //
  // methods
  //

  /** Set the 1-Wire net line level to strong pullup for a specified time.
      Adapter for time specification in strongPullup_t.
      @param    inPullup    Pullup time.
   */
  void strongPullup( const strongPullup_t inPullup);

};

#endif
