/***************************************************************************
                          LOW_sharedMemSegmentSysV.cpp  -  description
                             -------------------
    begin                : Tue Jul 30 2002
    copyright            : (C) 2002 by Harald Roelle, Helmut Reiser
    email                : roelle@informatik.uni-muenchen.de, reiser@informatik.uni-muenchen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
       
       
#include <errno.h>
#include <sys/ipc.h>
#include <sys/shm.h>

 
#include "LOW_sharedMemSegment_SysV.h"


//=====================================================================================
//
// constructors
//

LOW_sharedMemSegment_SysV::LOW_sharedMemSegment_SysV( const LOW_sharedMemSegmentFactory::sharedMemSegmentIPCKey_t inKey, const unsigned int inSize) :
  sharedMemSegKey( inKey)
{
  if ( (sharedMemSegID=shmget( sharedMemSegKey, inSize, SHM_PERMS)) == -1 ) {
  
    if ( errno == ENOENT ) {  // existed not yet, so create new segment

      if ( (sharedMemSegID=shmget( sharedMemSegKey, inSize, SHM_PERMS | IPC_CREAT)) == -1 )  // create segment
        throw sharedMemSeg_error( errno, "Failed to create new shared memory segment", __FILE__, __LINE__);

    }
    else {
      throw sharedMemSeg_error( errno, "Error getting shared memory segment", __FILE__, __LINE__);
    }
  }

  if ( (sharedMemPtr=shmat( sharedMemSegID, 0, 0)) == (void*)-1 )
    throw sharedMemSeg_error( errno, "Error attaching shared memory segment", __FILE__, __LINE__);
}


LOW_sharedMemSegment_SysV::~LOW_sharedMemSegment_SysV()
{
  struct shmid_ds  dummy;
  shmctl( sharedMemSegID, IPC_RMID, &dummy);
  shmdt( sharedMemPtr);
}



//=====================================================================================
//
// methods
//
  
void* LOW_sharedMemSegment_SysV::get() const
{
  return sharedMemPtr;
}

