/***************************************************************************
                          LOW_sharedMemSegmentSysV.h  -  description
                             -------------------
    begin                : Tue Jul 30 2002
    copyright            : (C) 2002 by Harald Roelle, Helmut Reiser
    email                : roelle@informatik.uni-muenchen.de, reiser@informatik.uni-muenchen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LOW_SHAREDMEMSEGMENT_SYSV_H
#define LOW_SHAREDMEMSEGMENT_SYSV_H


#include "LOW_sharedMemSegment.h"
#include "LOW_sharedMemSegmentFactory.h"


/** Platform specific sharedMemSegment for Unix System V platforms.

    @author Harald Roelle, Helmut Reiser
 */
class LOW_sharedMemSegment_SysV : public LOW_sharedMemSegment  {

//=======================================================================================
public: 
  
  //=====================================================================================
  //
  // constructors
  //
  
  /** Constructor.
      @param inSharedMemIPCKey  Unique identifier for new shared memory segment.
                                To get such an identifier see LOW_IPCKeyGenerator.
      @param inSize             Size of the segment in bytes.
   */
  LOW_sharedMemSegment_SysV( const LOW_sharedMemSegmentFactory::sharedMemSegmentIPCKey_t inKey,
                             const unsigned int inSize);

  /** Destructor.
   */  
  virtual ~LOW_sharedMemSegment_SysV();


  //=====================================================================================
  //
  // methods
  //
  
  void* get() const;

  
//=======================================================================================
private: 

  //=====================================================================================
  //
  // constants
  //
  
  static const int SHM_PERMS = 0770;  /**< Permissions for the shm segments. */
  
  
  //=====================================================================================
  //
  // attributes
  //
  
  const key_t         sharedMemSegKey;  /**< IPC key of the segment. */
  int                 sharedMemSegID;   /**< Sys V segment ID. */
  void*               sharedMemPtr;     /**< Pointer to the segment. */
};

#endif
