/***************************************************************************
                          test_link.cpp  -  description
                             -------------------
    begin                : Fri Jan 10 2003
    copyright            : (C) 2003 by Harald Roelle, Helmut Reiser
    email                : roelle@informatik.uni-muenchen.de, reiser@informatik.uni-muenchen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <typeinfo>

#include "LOW_portSerial.h"
#include "LOW_link.h"
#include "LOW_linkDS2480B.h"
#include "LOW_linkPassiveSerial.h"
#include "LOW_network.h"

#include "helper.h"



LOW_portSerialFactory::portSpecifier_t getSerialPortSpecifier()
{
  char port[256];
  hlp_printDashline();
  printf( "Enter full path to serial port device -> ");
  scanf( "%255s", port);
  return std::string( port);
}


void addActiveLink( LOW_link::linkPtrVec_t &inLinkList, LOW_network &inNet)
{
  LOW_linkDS2480B  *activeLink = 0;
  try {
    LOW_portSerialFactory::portSpecifier_t  tty = getSerialPortSpecifier();

    LOW_linkDS2480B::RXPOL_val_t  rxPol;
    vector<string> optRxPol;
    optRxPol.push_back( "RX polarity normal");
    optRxPol.push_back( "RX polarity inverted");
    unsigned int result = hlp_selectSingleOption( "RX pin polarity", optRxPol, 1);
    switch( result ) {
      case 0: rxPol = LOW_linkDS2480B::RXPOL_NORM;
      case 1: rxPol = LOW_linkDS2480B::RXPOL_INV;
    }

    bool extPower      = hlp_selectBoolOption( "Supplies external power", true);
    bool allowPrgPulse = hlp_selectBoolOption( "Allow EPROM program pulse", false);

    activeLink = new LOW_linkDS2480B( tty, LOW_linkDS2480B::RXPOL_INV, extPower, allowPrgPulse);
    inLinkList.push_back( activeLink);
    inNet.addLink( activeLink);
  }
  catch( LOW_exception ex) {
    ex.logException();
    if ( activeLink ) delete activeLink;
  }
}


void addPassiveLink( LOW_link::linkPtrVec_t &inLinkList, LOW_network &inNet)
{
  LOW_linkPassiveSerial  *passiveLink = 0;
  try {
    LOW_portSerialFactory::portSpecifier_t  tty = getSerialPortSpecifier();

    passiveLink = new LOW_linkPassiveSerial( tty);
    inLinkList.push_back( passiveLink);
    inNet.addLink( passiveLink);
  }
  catch( LOW_exception ex) {
    ex.logException();
    if ( passiveLink ) delete passiveLink;
  }
}


void removeLink( LOW_link::linkPtrVec_t &inLinkList, LOW_network &inNet)
{
  if ( inLinkList.size() == 0 ) {
    LOW_helper_msglog::printMessage( "No links to remove.\n");
    return;
  }
  
  vector<string> options;
  for( unsigned int a=0; a<inLinkList.size(); a++) {
    options.push_back( "Link Nr. "+a);
  }
  unsigned int result = hlp_selectSingleOption( "Select link to remove", options, 0);

  inNet.removeLink( inLinkList[result]);
  delete inLinkList[result];
  inLinkList.erase( inLinkList.begin()+result);
}


void linkInfo( LOW_link::linkPtrVec_t &inLinkList)
{
  hlp_printDashline();
  for( unsigned int a=0; a<inLinkList.size(); a++) {
    LOW_helper_msglog::printMessage( "Link %d:\n", a);
    LOW_helper_msglog::printMessage( "  Adapter type: %s\n", typeid( *(inLinkList[a])).name());
    LOW_helper_msglog::printMessage( "  \n");
  }
  LOW_helper_msglog::printMessage( "Total %d links.\n", inLinkList.size());
}


void linkMenu( LOW_link::linkPtrVec_t &inLinkList, LOW_network &inNet)
{
  bool keepLooping = true;
  while ( keepLooping) {
    hlp_printDashline();
    printf( "Links menu\n");
    printf( "\n");
    printf( "  Number of links: %d\n", inLinkList.size());
    printf( "\n");
    printf( "  <a> Add active link to network\n");
    printf( "  <p> Add passive link to network\n");
    printf( "  <r> Remove link from network\n");
    printf( "  <i> Infos on link\n");
    printf( "\n");
    printf( "  <q> Back to main menu\n");

    int key = hlp_getMenuKey( "apriq");

    try {
      switch( key ) {
        case 'a': addActiveLink( inLinkList, inNet);              break;
        case 'p': addPassiveLink( inLinkList, inNet);             break;
        case 'r': removeLink( inLinkList, inNet);                 break;
        case 'i': linkInfo( inLinkList);                          break;
        case 'q': keepLooping=false;                              break;
      }
    }
    catch( LOW_exception ex) {
      ex.logException();
    }
  }
}
