/***************************************************************************
                          LOW_sharedMemSegment.h  -  description
                             -------------------
    begin                : Tue Jul 30 2002
    copyright            : (C) 2002 by Harald Roelle, Helmut Reiser
    email                : roelle@informatik.uni-muenchen.de, reiser@informatik.uni-muenchen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LOW_SHAREDMEMSEGMENT_H
#define LOW_SHAREDMEMSEGMENT_H


#include "LOW_exception.h"


/** Abstract base class for shared memory segments.
    Each instance represents one shared memory segment.

    Specific platforms dereive their implementation classes from this class.

    The instances are created by LOW_sharedMemSegmentFactory, following the factory
    design pattern.

    <B>Note:</B> There is no prescribed constructor. A class deriving from this
                 class should give the opportunity to specify the size of the segment.

    @see LOW_sharedMemSegmentFactory

    @author Harald Roelle, Helmut Reiser
 */
class LOW_sharedMemSegment {

//=======================================================================================
public: 
  
  //=====================================================================================
  //
  // exceptions
  //
 
  /** Exception base class for all exceptions thrown by LOW_sharedMemSegment. */
  class_DERIVE_FROM_EXCEPTION( sharedMemSeg_error, LOW_exception);
  
  
  //=====================================================================================
  //
  // methods
  //

  
  /** Get a pointer to the shared memory segment.
      Abstract method to be implemented by derived class.
      @return  Pointer to the shared memory segment.
   */
  virtual void* get() const = 0;
};

#endif
