/***************************************************************************
                          LOW_semaphoreSetSysV.h  -  description
                             -------------------
    begin                : Mon Jul 29 2002
    copyright            : (C) 2002 by Harald Roelle, Helmut Reiser
    email                : roelle@informatik.uni-muenchen.de, reiser@informatik.uni-muenchen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LOW_SEMAPHORESET_SYSV_H
#define LOW_SEMAPHORESET_SYSV_H


#include "LOW_semaphoreSet.h"
#include "LOW_semaphoreSetFactory.h"



/** Platform specific semaphoreSet for Unix System V platforms.

    @author Harald Roelle, Helmut Reiser
 */
class LOW_semaphoreSet_SysV : public LOW_semaphoreSet {

//=======================================================================================
public: 
  
  //=====================================================================================
  //
  // constructors
  //
  
  /** Constructor.
  
      @param inSemSetIPCKey  Unique identifier for new shared memory segment.
                             To get such an identifier see LOW_IPCKeyGenerator.
      @param inSemCount      Number of semaphores in set.
      @param inInitVal       Initial values of semaphores.
   */
  LOW_semaphoreSet_SysV( const LOW_semaphoreSetFactory::semSetIPCKey_t inKey,
                         const unsigned int inSemCount, const unsigned int inInitVal);

  /** Destructor.
   */
  virtual ~LOW_semaphoreSet_SysV();


  //=====================================================================================
  //
  // methods
  //
  
  void decSem( const unsigned int inSemNo) const;
  
  void incSem( const unsigned int inSemNo) const;

  
//=======================================================================================
private: 

  //=====================================================================================
  //
  // constants
  //
  
  static const int SEM_PERMS = 0770;  /**< Permissions for the semaphore set. */
  
  
  //=====================================================================================
  //
  // attributes
  //
  
  const key_t         semSetKey;   /**< IPC key of the segment. */
  int                 semSetID;    /**< Sys V segment ID. */

};

#endif
