/***************************************************************************
                          LOW_sharedMemSegmentFactory.h  -  description
                             -------------------
    begin                : Tue Jul 30 2002
    copyright            : (C) 2002 by Harald Roelle, Helmut Reiser
    email                : roelle@informatik.uni-muenchen.de, reiser@informatik.uni-muenchen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LOW_SHAREDMEMSEGMENTFACTORY_H
#define LOW_SHAREDMEMSEGMENTFACTORY_H


#include <sys/types.h>

#include "LOW_sharedMemSegment.h"



/** Factory class for platform specific objects of LOW_sharedMemSegment.

    This class also contains platform specific type definitions.

    @see LOW_sharedMemSegment

    @author Harald Roelle, Helmut Reiser
 */
class LOW_sharedMemSegmentFactory {

//=======================================================================================
public: 

  //=====================================================================================
  //
  // type definitions
  //

#ifdef __linux__
  /** Linux specific type for shared memory unique identifier. */
  typedef key_t   sharedMemSegmentIPCKey_t;
#endif
  
  //=====================================================================================
  //
  // static factory
  //

  /** Platform aware replacement for creating dynamic instances of LOW_sharedMemSegment.
      @param inSharedMemIPCKey  Unique identifier for new shared memory segment.
                                To get such an identifier see LOW_IPCKeyGenerator.
      @param inSize             Size of the segment in bytes.
      @return  Pointer to new instance of LOW_sharedMemSegment.
   */
  static LOW_sharedMemSegment* new_sharedMemSegment( const sharedMemSegmentIPCKey_t inSharedMemIPCKey, unsigned int inSize);

};

#endif
